var socket;
var new_uri;
var termId;
var contextRoot;
var replContextRoot;
//$(document).ready(init);

//isLoading=false;
//isloadingOverlay();

const waitForOpenConnection = (socket) => {
    return new Promise((resolve, reject) => {
        const maxNumberOfAttempts = 10
        const intervalTime = 200 //ms

        let currentAttempt = 0
        const interval = setInterval(() => {
            if (currentAttempt > maxNumberOfAttempts - 1) {
                clearInterval(interval)
                reject(new Error('Maximum number of attempts exceeded'))
            } else if (socket.readyState === socket.OPEN) {
                clearInterval(interval)
                resolve()
            }
            currentAttempt++
        }, intervalTime)
    })
}

const sendMessage = async (socket, msg) => {
    if (socket.readyState !== socket.OPEN) {
        try {
            await waitForOpenConnection(socket)
            socket.send(msg)
        } catch (err) { console.error(err) }
    } else {
        socket.send(msg)
    }
}

function init() {
//    isloadingOverlay();
    var loc = window.location;
    var pathArray = loc.pathname.split( '/' );
    
    if (loc.protocol === "https:") {
        new_uri = "wss:";
    } else {
        new_uri = "ws:";
    }
    new_uri += "//" + loc.host;
    contextRoot = "";
    if (pathArray[1] !== "servlet") {    
        contextRoot = pathArray[1];
        new_uri += "/" + contextRoot;
    }
    new_uri += "/terminalwebsocket";
    
    if (contextRoot !== "") {
        replContextRoot = "/" + contextRoot;
    } else {
        replContextRoot = "";
    }
    
    connect();

}

function openModal() {
	$('#ModalPopup').on('show', function() {
	    $('body').append('<div class="modal-backdrop"></div>');
	});
	$('#ModalPopup').on('hide', function() {
	    $('body').find('.modal-backdrop').remove();
	});

	$('#ModalPopup').modal('show');


        function sendForm(dialog,form,pressed) {
           var valid = true;
           
           var values = {};
           $.each(dialog.find( "form" ).serializeArray(), function(i, field) {
               values[field.name] = field.value;
           });

          
           if (valid){
           
        	  dialog.modal('hide');
         
              var sendString="BUTTON=" + pressed + "|";
              for (const [key, value] of Object.entries(values)) {
            	  sendString+=key + "=" + value + "|";
            	}
              sendMessage(socket, sendString);
           }
           return valid;
        }

        dialog = $("#ModalPopup");
        
        form = dialog.find( "form" ).on( "submit", function( event ) {
             pressed = event.originalEvent.submitter.name
             event.preventDefault();
             sendForm(dialog,form,pressed);
         });         
}

function connect(){
    try{
    	if (socket == null) {
            socket = new WebSocket(new_uri);
    	}
           
        socket.onopen = sendMessage(socket, "termId="+termId);

        socket.onmessage = function(event){
//            socket.close(); //keeping socket open for push notifications
            var msg = event.data;
            if (msg.startsWith("htmlMsg=")) {
            	//remove id from DOM if it exists
            	$("#ModalPopup").remove();
            	document.body.innerHTML+=msg.substring(7);
            	$.isLoading( "hide" );
            	openModal();
            } else {
              // similar behavior as an HTTP redirect
              window.location.replace(replContextRoot + event.data);
            }
        }
        socket.onclose = function(){
               //message('<p class="event">Socket Status: '+socket.readyState+' (Closed)');
        }            

   } catch(exception){
       console.log(exception);
   }
}
